package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;

import java.util.List;

import de.davidartmann.rosa.R;
import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask for loading the data from the db.
 * Created by david on 02.03.16.
 */
public class FindAllInactivePersonsFromDb extends AsyncTask<String, Integer, List<Person>> {

    private Context context;
    private IFindAllInactivePersonsFromDb iFindAllInactivePersonsFromDb;
    private PersonDao personDao;

    public FindAllInactivePersonsFromDb(Context context,
                                IFindAllInactivePersonsFromDb iFindAllInactivePersonsFromDb) {
        this.context = context;
        this.iFindAllInactivePersonsFromDb = iFindAllInactivePersonsFromDb;
    }

    @Override
    protected List<Person> doInBackground(String... params) {
        personDao = new PersonDao(context);
        personDao.openReadable();
        return personDao.findAllInactive();
    }

    @Override
    protected void onPostExecute(List<Person> persons) {
        super.onPostExecute(persons);
        iFindAllInactivePersonsFromDb.onFindAllInactive(persons);
        personDao.close();
    }

    public interface IFindAllInactivePersonsFromDb {
        void onFindAllInactive(List<Person> persons);
    }
}
